capture log close
clear all
macro drop _all
cd "C:\Users\alice\Quantonomics Dropbox\Quantonomics Team Folder\AER25\1. Opex Function Development\Attachment B\Time-varying Models-AG-31Jul2025\Correlation Elasticities"
set more off

log using Output/elastcorr, replace text

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function - Time-Varying Models
			Elasticities correlations
Author:  Alice Giovani & Michael Cunningham
File:    anElastCorr.do
Initial Date:    31-Jul-2025
Revised Date:	 

--------------------------------------------------------------------------*/
tempfile data1

* Read data - Standard SFATLG-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("Standard-SFATLG-LP") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Standard SFATLG\Standard-SFATLG-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Standard SFATLG\Standard-SFATLG-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Standard SFATLG\Standard-SFATLG-LP-cl.png", width(1800) replace

* Read data - Standard LSETLG-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("Standard-LSETLG-LP ") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Standard LSETLG\Standard-LSETLG-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Standard LSETLG\rmd-Standard-LSETLG-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Standard LSETLG\CL-Standard-LSELG-LP-cl.png", width(1800) replace

	
* Read data - SFA-BC95-JTT-HN-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("SFA-BC95-JTT-HN-LP") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\SFA-BC95-JTT-HN\SFA-BC95-JTT-HN-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\SFA-BC95-JTT-HN\SFA-BC95-JTT-HN-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\SFA-BC95-JTT-HN\SFA-BC95-JTT-HN-LP-cl.png", width(1800) replace

* Read data - Kumb90-JTT-HN-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("Kumb90-JTT-HN-LP") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-JTT-HN\Kumb90-JTT-HN-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-JTT-HN\Kumb90-JTT-HN-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-JTT-HN\Kumb90-JTT-HN-LP-cl.png", width(1800) replace
	
* Read data - Kumb90-JTT-HN-GTC-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("Kumb90-JTT-HN-GTC-LP") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-JTT-HN-GTC\Kumb90-JTT-HN-GTC-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-JTT-HN-GTC\Kumb90-JTT-HN-GTC-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-JTT-HN-GTC\Kumb90-JTT-HN-GTC-LP-cl.png", width(1800) replace

* Read data - Kumb90-AJTT-HN-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("Kumb90-AJTT-HN-LP") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTT-HN\Kumb90-AJTT-HN-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTT-HN\Kumb90-AJTT-HN-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTT-HN\Kumb90-AJTT-HN-LP-cl.png", width(1800) replace

* Read data - Kumb90-AJTT-HN-GTC-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("Kumb90-AJTT-HN-GTC-LP") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTT-HN-GTC\Kumb90-AJTT-HN-GTC-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTT-HN-GTC\Kumb90-AJTT-HN-GTC-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTT-HN-GTC\Kumb90-AJTT-HN-GTC-LP-cl.png", width(1800) replace

* Read data - Kumb90-AJTTnz-HN-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("Kumb90-AJTTnz-HN-LP") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTTnz-HN\Kumb90-AJTTnz-HN-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTTnz-HN\Kumb90-AJTTnz-HN-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTTnz-HN\Kumb90-AJTTnz-HN-LP-cl.png", width(1800) replace

* Read data - Kumb90-AJTTnz-HN-GTC-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("Kumb90-AJTTnz-HN-GTC-LP") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTTnz-HN-GTC\Kumb90-AJTTnz-HN-GTC-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTTnz-HN-GTC\Kumb90-AJTTnz-HN-GTC-HN-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTTnz-HN-GTC\Kumb90-AJTTnz-HN-GTC-LP-cl.png", width(1800) replace
	
* Read data - LSE-ADTT-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("LSE-ADTT-LP") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-ADTT\LSE-ADTT-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-ADTT\LSE-ADTT-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-ADTT\LSE-ADTT-LP-cl.png", width(1800) replace
	
* Read data - LSE-ADTT-GTC-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("LSE-ADTT-GTC-LP") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-ADTT-GTC\LSE-ADTT-GTC-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-ADTT-GTC\LSE-ADTT-GTC-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-ADTT-GTC\LSE-ADTT-GTC-LP-cl.png", width(1800) replace
	
* Read data - LSE-AJTT-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("LSE-AJTT-LP") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-AJTT\LSE-AJTT-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-AJTT\LSE-AJTT-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-AJTT\LSE-AJTT-LP-cl.png", width(1800) replace
	
* Read data - LSE-AJTT-GTC-LP
import excel Input/ElasticityCorr.xlsx, clear sheet("LSE-AJTT-GTC-LP") ///
	cellrange(A1:I1099) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-AJTT-GTC\LSE-AJTT-GTC-LP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-AJTT-GTC\LSE-AJTT-GTC-LP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-AJTT-GTC\LSE-AJTT-GTC-LP-cl.png", width(1800) replace
	
**

* Read data - Standard SFATLG-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("Standard-SFATLG-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Standard SFATLG\Standard-SFATLG-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Standard SFATLG\Standard-SFATLG-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Standard SFATLG\Standard-SFATLG-SP-cl.png", width(1800) replace

* Read data - Standard LSETLG-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("Standard-LSETLG-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Standard LSETLG\Standard-LSETLG-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Standard LSETLG\Standard-LSETLG-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Standard LSETLG\Standard-LSELG-SP-cl.png", width(1800) replace

	
* Read data - SFA-BC95-JTT-HN-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("SFA-BC95-JTT-HN-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\SFA-BC95-JTT-HN\SFA-BC95-JTT-HN-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\SFA-BC95-JTT-HN\SFA-BC95-JTT-HN-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\SFA-BC95-JTT-HN\SFA-BC95-JTT-HN-SP-cl.png", width(1800) replace

* Read data - Kumb90-JTT-HN-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("Kumb90-JTT-HN-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-JTT-HN\Kumb90-JTT-HN-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-JTT-HN\Kumb90-JTT-HN-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-JTT-HN\Kumb90-JTT-HN-SP-cl.png", width(1800) replace
	
* Read data - Kumb90-JTT-HN-GTC-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("Kumb90-JTT-HN-GTC-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-JTT-HN-GTC\Kumb90-JTT-HN-GTC-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-JTT-HN-GTC\Kumb90-JTT-HN-GTC-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-JTT-HN-GTC\Kumb90-JTT-HN-GTC-SP-cl.png", width(1800) replace

* Read data - Kumb90-AJTT-HN-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("Kumb90-AJTT-HN-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTT-HN\Kumb90-AJTT-HN-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTT-HN\Kumb90-AJTT-HN-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTT-HN\Kumb90-AJTT-HN-SP-cl.png", width(1800) replace

* Read data - Kumb90-AJTT-HN-GTC-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("Kumb90-AJTT-HN-GTC-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTT-HN-GTC\Kumb90-AJTT-HN-GTC-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTT-HN-GTC\Kumb90-AJTT-HN-GTC-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTT-HN-GTC\Kumb90-AJTT-HN-GTC-SP-cl.png", width(1800) replace

* Read data - Kumb90-AJTTnz-HN-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("Kumb90-AJTTnz-HN-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTTnz-HN\Kumb90-AJTTnz-HN-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTTnz-HN\Kumb90-AJTTnz-HN-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTTnz-HN\Kumb90-AJTTnz-HN-SP-cl.png", width(1800) replace

* Read data - Kumb90-AJTTnz-HN-GTC-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("Kumb90-AJTTnz-HN-GTC-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTTnz-HN-GTC\Kumb90-AJTTnz-HN-GTC-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTTnz-HN-GTC\Kumb90-AJTTnz-HN-GTC-HN-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\Kumb90-AJTTnz-HN-GTC\Kumb90-AJTTnz-HN-GTC-SP-cl.png", width(1800) replace
	
* Read data - LSE-ADTT-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("LSE-ADTT-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-ADTT\LSE-ADTT-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-ADTT\LSE-ADTT-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-ADTT\LSE-ADTT-SP-cl.png", width(1800) replace
	
* Read data - LSE-ADTT-GTC-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("LSE-ADTT-GTC-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-ADTT-GTC\LSE-ADTT-GTC-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-ADTT-GTC\LSE-ADTT-GTC-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-ADTT-GTC\LSE-ADTT-GTC-SP-cl.png", width(1800) replace
	
* Read data - LSE-AJTT-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("LSE-AJTT-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-AJTT\LSE-AJTT-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-AJTT\LSE-AJTT-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-AJTT\LSE-AJTT-SP-cl.png", width(1800) replace
	
* Read data - LSE-AJTT-GTC-SP
import excel Input/ElasticityCorr.xlsx, clear sheet("LSE-AJTT-GTC-SP") ///
	cellrange(A1:I733) firstrow 
	
gen elast_tot = ely1 + ely2 + ely3

pwcorr custnum circlen elast_tot
pwcorr custnum circlen elast_tot if country == "1.Aust"
pwcorr custnum circlen elast_tot if eiid == "Evoenergy"
pwcorr custnum circlen elast_tot if eiid == "Ausgrid"
pwcorr custnum circlen elast_tot if eiid == "CitiPower"
pwcorr custnum circlen elast_tot if eiid == "Endeavour Energy"
pwcorr custnum circlen elast_tot if eiid == "Energex"
pwcorr custnum circlen elast_tot if eiid == "Ergon Energy"
pwcorr custnum circlen elast_tot if eiid == "Essential Energy"
pwcorr custnum circlen elast_tot if eiid == "Jemena"
pwcorr custnum circlen elast_tot if eiid == "Powercor"
pwcorr custnum circlen elast_tot if eiid == "SA Power Networks"
pwcorr custnum circlen elast_tot if eiid == "AusNet Dist"
pwcorr custnum circlen elast_tot if eiid == "TasNetworks Dist"
pwcorr custnum circlen elast_tot if eiid == "United Energy"

twoway ///
    (scatter elast_tot custnum if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot custnum if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot custnum if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("Customer Numbers") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-AJTT-GTC\LSE-AJTT-GTC-SP-cust.png", width(1800) replace


twoway ///
    (scatter elast_tot rmdem if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot rmdem if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("RMD") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-AJTT-GTC\LSE-AJTT-GTC-SP-rmd.png", width(1800) replace

twoway ///
    (scatter elast_tot circlen if country == "1.Aust", mcolor(blue) msymbol(o)) ///
    (scatter elast_tot circlen if country == "2.NZ", mcolor(red) msymbol(o)) ///
    (scatter elast_tot circlen if country == "3.Ontario", mcolor(green) msymbol(o)), ///
    xtitle("CL") ///
    ytitle("Elasticity Total") ///
    legend(order(1 "AUS" 2 "NZ" 3 "ONT"))

graph export "Output\LSE-AJTT-GTC\LSE-AJTT-GTC-SP-cl.png", width(1800) replace

	
log close
exit
